/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class EtherNetIP
extends PropertyPage {
    private AbstractNode node;
    private LabeledSpinner tcpPort;
    private ObjectSelector proxy;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.horizontalSpacing = 5;
        dialogLayout.numColumns = 2;
        dialogArea.setLayout((Layout)dialogLayout);
        this.tcpPort = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.tcpPort.setLabel(Messages.Communication_TCPPort);
        this.tcpPort.setRange(1, 65535);
        this.tcpPort.setSelection(this.node.getEtherNetIpPort());
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        this.tcpPort.setLayoutData((Object)gd);
        this.proxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.proxy.setLabel(Messages.Communication_Proxy);
        this.proxy.setObjectId(this.node.getEtherNetIpProxyId());
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.proxy.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        md.setEtherNetIPPort(this.tcpPort.getSelection());
        md.setEtherNetIPProxy(this.proxy.getObjectId());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating EtherNet/IP communication settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update EtherNet/IP communication settings for node %s", EtherNetIP.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            EtherNetIP.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.tcpPort.setText("44818");
        this.proxy.setObjectId(0L);
    }
}

