/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class BootstrapLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ClassLoader bootClassLoader = BootstrapLoader.class.getClassLoader();
        URLClassLoader classLoader = null;
        try {
            String version;
            ArrayList<URL> classPath = new ArrayList<URL>();
            Manifest manifest = null;
            Enumeration<URL> manifests = bootClassLoader.getResources("META-INF/MANIFEST.MF");
            while (manifests.hasMoreElements()) {
                manifest = new Manifest(manifests.nextElement().openStream());
                String mainClass = manifest.getMainAttributes().getValue("Main-Class");
                if (BootstrapLoader.class.getCanonicalName().equals(mainClass)) break;
                manifest = null;
            }
            if (manifest == null) {
                System.err.println("Cannot find correct MANIFEST.MF");
                return;
            }
            Attributes manifestAttributes = manifest.getMainAttributes();
            String dependencies = manifestAttributes.getValue("Class-Path");
            if (dependencies != null) {
                for (String jarName : dependencies.split(" ")) {
                    InputStream in = bootClassLoader.getResourceAsStream("BOOT-INF/core/" + jarName);
                    if (in == null) continue;
                    File jarFile = BootstrapLoader.extractLibrary(in, jarName.replace(".jar", "-"));
                    classPath.add(jarFile.toURI().toURL());
                }
            }
            if ((version = manifestAttributes.getValue("Package-Version")) != null) {
                InputStream in;
                String bootstrapPackage = manifestAttributes.getValue("Bootstrap-Package");
                if (bootstrapPackage == null) {
                    bootstrapPackage = "nxmc";
                }
                if ((in = bootClassLoader.getResourceAsStream("BOOT-INF/core/" + bootstrapPackage + "-" + version + ".jar")) != null) {
                    File jarFile = BootstrapLoader.extractLibrary(in, bootstrapPackage + "-");
                    classPath.add(jarFile.toURI().toURL());
                }
            }
            String os = System.getProperty("os.name").toLowerCase();
            String arch = System.getProperty("os.arch").toLowerCase();
            String swtVariant = null;
            if (os.contains("windows")) {
                swtVariant = "win32.win32.x86_64";
            } else if (os.equals("linux")) {
                if (arch.equals("amd64")) {
                    swtVariant = "gtk.linux.x86_64";
                } else if (arch.equals("aarch64")) {
                    swtVariant = "gtk.linux.aarch64";
                }
            } else if (os.contains("mac")) {
                if (arch.equals("amd64")) {
                    swtVariant = "cocoa.macosx.x86_64";
                } else if (arch.equals("aarch64")) {
                    swtVariant = "cocoa.macosx.aarch64";
                }
            }
            if (swtVariant == null) {
                System.err.println("Unsupported OS/architecture combination (os=" + os + " arch=" + arch + ")");
                return;
            }
            String swtVersion = manifestAttributes.getValue("SWT-Version");
            InputStream in = BootstrapLoader.class.getClassLoader().getResourceAsStream("BOOT-INF/swt/org.eclipse.swt." + swtVariant + "-" + swtVersion + ".jar");
            if (in == null) {
                System.err.println("Cannot load SWT library for detected OS/architecture combination (os=" + os + " arch=" + arch + ")");
                return;
            }
            File swtJar = BootstrapLoader.extractLibrary(in, "swt-" + swtVersion + "-");
            classPath.add(swtJar.toURI().toURL());
            classLoader = new URLClassLoader("nxmc-loader", classPath.toArray(new URL[classPath.size()]), bootClassLoader);
            Class<?> startupClass = classLoader.loadClass("org.netxms.nxmc.Startup");
            Method main = startupClass.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (classLoader != null) {
                try {
                    classLoader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibrary(InputStream in, String name) throws Exception {
        File jarFile = File.createTempFile(name, ".jar");
        jarFile.deleteOnExit();
        try (FileOutputStream out = new FileOutputStream(jarFile);){
            int length;
            byte[] buffer = new byte[16384];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        return jarFile;
    }
}

